# Vertragsabschluss

Ein Vertrag gilt als abgeschlossen, sobald er von den Vertragspartnern unterschrieben wurde. In der Regel wartet er dann auf sein Inkrafttreten, sofern dieses nicht unmittelbar gewählt wurde. Neben dem Datum der Unterzeichnung ist also besonders das Datum des Vertragsbeginns von Bedeutung.

> <span
style='font-style:italic'>Im Anschluss an eine Vertragsverhandlung markiert der Vertragsverantwortliche diesen als abgeschlossen. Neben dem Datum des Abschlusses trägt er auch einen Kommentar ein, der über den Ausgang der Verhandlung informiert. </span>

{@img img1.png}

<span class="tag_important">Mit dem Abschluss eines Vertrages gilt das hinterlegte Vertragsdokument als final. Weitere Anpassungen bedürfen des Einverständnisses beider Vertragspartner.</span>

<span class="tag_warning">Verträge, die rechtskräftig sind, müssen als abgeschlossen markiert werden. Dies erlaubt eine Berechnung nach aktiven und inaktiven Verträgen.</span>

## Aktion: Vertrag abschließen

Die Aktion kann im Reiter `Verträge` der Multifunktionsleiste aufgerufen werden. 

{@img img3.png}

### Vorbedingungen

*   Ein Vertrag ist ausgewählt.

### Dateneingabe

Für die Dateneingabe wird die Formular-Tab-Gruppe `004_sign_contract` eingesetzt. 

{@img img5.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Vertragsabschluss</span></td><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>620_conclusion</td><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td></td><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td></td><td>230_contract_data</td><td></td><td></td><td></td></tr><tr><td></td><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td></td><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration `sol.contract.ContractConcluded`.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die Index Server Aktion `sol.contract.ix.actions.ConcludeContract` implementiert. Diese startet den Workflow `sol.contract.contract.conclude`.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td>Event</td><td>Beschreibung</td><td>Status</td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an.</td><td></td></tr><tr><td>REFRESH</td><td>Aktualisiert die Darstellung des SORD-Objekts.</td><td></td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img7.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>Contract conclusion</span></td><td><span
style='font-weight:bold'>Vertragsabschluss</span><br />Benutzerknoten: Markierung eines Vertrags als abgeschlossen.</td><td></td></tr><tr><td><span
style='font-weight:bold'>STATUS: Concluded</span></td><td><span
style='font-weight:bold'>STATUS: Abgeschlossen</span><br />Verteilungsknoten: Setzt das Indexfeld CONTRACT_STATUS auf `S`</td><td>sol.common.ix.functions.Status</td></tr><tr><td><span
style='font-weight:bold'>CHANGECOLOR: Contract concluded</span></td><td><span
style='font-weight:bold'>CHANGECOLOR: Vertrag abgeschlossen</span><br />Verteilungsknoten: Setzt die Farbe des SORD Objekts</td><td>sol.common.ix.functions.ChangeColor</td></tr><tr><td><span
style='font-weight:bold'>FEED: Contract concluded</span></td><td><span
style='font-weight:bold'>FEED: Vertrag abgeschlossen</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zum Verhandlungsabschluss an.</td><td>sol.common.ix.functions.FeedComment</td></tr></tbody></table>


